from decouple import config
from rest_framework.decorators import api_view
from rest_framework.response import Response
from django.core.mail import send_mail
from django.shortcuts import render
from django.views.decorators.csrf import csrf_exempt
from django.http import JsonResponse

@csrf_exempt
@api_view(['GET'])
def api_status(request):
    if request.method == 'OPTIONS':
        response = JsonResponse({})
        response["Access-Control-Allow-Origin"] = "https://gruporequiez.com"  # Reemplaza con el dominio correcto
        response["Access-Control-Allow-Methods"] = "GET, POST, OPTIONS"
        response["Access-Control-Allow-Headers"] = "Content-Type"
        return response

    return JsonResponse({"message": "API funcionando correctamente"})

@csrf_exempt 
@api_view(['POST'])
def enviar_correo_api(request):
    if request.method == 'POST':
        subject = request.data.get('subject', 'Grupo Requiez Arrendamiento')
        message = request.data.get('message', 'Datos de Formulario de contacto')

        # Tomar los valores de los campos empresa, nombre, correo, telefono, ciudad
        empresa = request.data.get('empresa', '')
        nombre = request.data.get('nombre', '')
        correo = request.data.get('correo', '')
        telefono = request.data.get('telefono', '')
        ciudad = request.data.get('ciudad', '')

        # Tomar los valores de los correos de envío y recepción desde settings.py
        from_email = config('EMAIL_HOST_USER')  # Reemplaza con el valor correcto
        recipient_email = config('EMAIL_HOST_DEST') # Reemplaza con el valor correcto

        # Construir el mensaje de correo incluyendo los datos de la solicitud POST
        message += f'\nEmpresa: {empresa}\n'
        message += f'Nombre: {nombre}\n'
        message += f'Correo: {correo}\n'
        message += f'Telefono: {telefono}\n'
        message += f'Ciudad: {ciudad}\n'

        try:
            send_mail(subject, message, from_email, [recipient_email], fail_silently=False)
            return Response({'message': 'Correo enviado exitosamente'})
        except Exception as e:
            return Response({'error': str(e)}, status=500)

    return Response({'error': 'Método no permitido'}, status=405)
